
# Application Config Guide

## Overview
Rendering Engine applications can be configured using a JSON-based configuration file.
Each new project generated by the project creation tool includes a template config file:
```bash
RenderingEngine/Scripts/Templates/Config/app_config.json.in
```
Within an actual project, this file appears as:

```bash
<Project>/Config/app_config.json.in
```
During the build process, this file is copied into the application’s build directory, where the engine reads it at startup.

## Configuration File Layout
A configuration file has the following structure:
```json
{
  "appName": "@PROJECT_NAME@",
  "isFullScreen": false,
  "screenWidth": 800,
  "screenHeight": 600
}
```
Default values are used if the configuration file is missing or contains invalid data.

## Runtime Structure
At runtime, these values are read into the following structure:
```cpp
struct AppConfig
{
	/** @brief Name of the application */
	std::string appName;
	/** @brief Whether the application should start in full-screen mode. */
	bool isFullScreen = false;
	/** @brief Desired window width in pixels (ignored in full-screen mode). */
	float screenWidth = 800.0f;
	/** @brief Desired window height in pixels (ignored in full-screen mode). */
	float screenHeight = 600.0f;
};
```
For details on how configuration loading is implemented, refer to:
```bash
RenderingEngine\RenderingLibrary\Include\utility.hpp
```

<- [Back to Developer Guide Page](developer_guide.md)

