# ======================================================================
# RenderingEngineConfig.cmake.in
# Installed CMake package configuration file.
# ======================================================================


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was RenderingEngineConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# Load exported engine targets
include("${CMAKE_CURRENT_LIST_DIR}/RenderingEngineTargets.cmake")

# Package version
set(RenderingEngine_VERSION "0.2.0")

# ======================================================================
# Public SDK include directories
# (exactly matching SDK layout)
# ======================================================================

set(RenderingEngine_INCLUDE_DIR
    "${CMAKE_CURRENT_LIST_DIR}/../../../Include"
)

set(RenderingEngine_EXTERNAL_DIR
    "${CMAKE_CURRENT_LIST_DIR}/../../../External"
)

set(RenderingEngine_INCLUDE_DIRS
    "${RenderingEngine_INCLUDE_DIR}"
    "${RenderingEngine_EXTERNAL_DIR}/glm"
    "${RenderingEngine_EXTERNAL_DIR}/boost"
)

# IMPORTANT:
# Do NOT export json, vulkan, freetype, glfw, stb, or any system includes.
# They must remain PRIVATE inside the engine.

# ======================================================================
# Path to engine library directory
# ======================================================================
set(RenderingEngine_LIBRARY_DIR
    "${CMAKE_CURRENT_LIST_DIR}/../.."
)

# ======================================================================
# Consumers simply use:
#
#   find_package(RenderingEngine REQUIRED)
#   target_link_libraries(app PRIVATE RenderingEngine::RenderingEngine)
#
# ======================================================================
